-- Sample Data for Financial Management System
-- Run this after installation to populate with demo data

USE financial_system;

-- Sample Chart of Accounts
INSERT INTO chart_of_accounts (company_id, account_code, account_name, account_type_id, parent_account_id, opening_balance, is_active) VALUES
(1, '1-1000', 'Cash and Cash Equivalents', 3, NULL, 50000000, 1),
(1, '1-1100', 'Cash on Hand', 3, 1, 10000000, 1),
(1, '1-1200', 'Cash in Bank', 3, 1, 40000000, 1),
(1, '1-2000', 'Accounts Receivable', 4, NULL, 25000000, 1),
(1, '1-3000', 'Inventory', 5, NULL, 75000000, 1),
(1, '2-1000', 'Accounts Payable', 8, NULL, 35000000, 1),
(1, '3-1000', 'Owner Equity', 11, NULL, 100000000, 1),
(1, '3-1100', 'Retained Earnings', 12, 11, 15000000, 1),
(1, '4-1000', 'Sales Revenue', 13, NULL, 0, 1),
(1, '4-1100', 'Service Revenue', 14, NULL, 0, 1),
(1, '5-1000', 'Cost of Goods Sold', 16, NULL, 0, 1),
(1, '5-1001', 'Purchases', 16, NULL, 0, 1),
(1, '5-1100', 'Office Expenses', 17, NULL, 0, 1),
(1, '5-1101', 'Utilities', 17, NULL, 0, 1),
(1, '5-1102', 'Marketing Expenses', 17, NULL, 0, 1);

-- Sample Item Categories
INSERT INTO item_categories (company_id, code, name, description) VALUES
(1, 'CAT-001', 'Electronics', 'Electronic devices and accessories'),
(1, 'CAT-002', 'Office Supplies', 'Office stationery and supplies'),
(1, 'CAT-003', 'Furniture', 'Office and home furniture'),
(1, 'CAT-004', 'Software', 'Software licenses and subscriptions');

-- Sample Items
INSERT INTO items (company_id, code, name, category_id, unit_of_measure, cost_method, min_stock, max_stock, is_active) VALUES
(1, 'ITM-001', 'Laptop Dell Inspiron 15', 1, 'pcs', 'FIFO', 5, 20, 1),
(1, 'ITM-002', 'Wireless Mouse Logitech', 1, 'pcs', 'FIFO', 10, 50, 1),
(1, 'ITM-003', 'Printer Epson L3210', 1, 'pcs', 'FIFO', 2, 10, 1),
(1, 'ITM-004', 'Office Chair Ergonomic', 3, 'pcs', 'FIFO', 5, 25, 1),
(1, 'ITM-005', 'A4 Paper 70gsm', 2, 'rim', 'FIFO', 50, 200, 1),
(1, 'ITM-006', 'Microsoft Office 365', 4, 'license', 'FIFO', 0, 0, 1);

-- Sample Customers
INSERT INTO customers (company_id, code, name, contact_person, address, phone, email, payment_terms, credit_limit) VALUES
(1, 'CUST-001', 'PT Maju Jaya Abadi', 'Budi Santoso', 'Jl. Sudirman No. 123, Jakarta', '021-12345678', 'budi@majujaya.com', 30, 50000000),
(1, 'CUST-002', 'CV Sukses Bersama', 'Siti Nurhaliza', 'Jl. Thamrin No. 45, Jakarta', '021-87654321', 'siti@suksesbersama.com', 30, 30000000),
(1, 'CUST-003', 'Toko Sejahtera', 'Ahmad Wahid', 'Jl. Merdeka No. 78, Jakarta', '021-55555555', 'ahmad@tokosejahtera.com', 15, 10000000);

-- Sample Suppliers
INSERT INTO suppliers (company_id, code, name, contact_person, address, phone, email, payment_terms) VALUES
(1, 'SUP-001', 'PT Teknologi Maju', 'Rina Kartika', 'Jl. Gatot Subroto No. 100, Jakarta', '021-98765432', 'rina@teknologimaju.com', 30),
(1, 'SUP-002', 'CV Sumber Baru', 'Dewi Lestari', 'Jl. Rasuna Said No. 25, Jakarta', '021-66666666', 'dewi@sumberbaru.com', 30),
(1, 'SUP-003', 'Toko Maju Mundur', 'Joko Susilo', 'Jl. Kuningan No. 50, Jakarta', '021-77777777', 'joko@majumundur.com', 15);

-- Sample Employees
INSERT INTO employees (company_id, employee_code, full_name, email, phone, address, date_of_birth, date_joined, position, department, basic_salary, allowance, tax_status) VALUES
(1, 'EMP-001', 'John Doe', 'john@company.com', '081234567890', 'Jl. Pahlawan No. 10, Jakarta', '1990-05-15', '2020-01-15', 'Sales Manager', 'Sales', 8000000, 2000000, 'TK/0'),
(1, 'EMP-002', 'Jane Smith', 'jane@company.com', '081298765432', 'Jl. Merdeka No. 20, Jakarta', '1988-08-20', '2019-03-10', 'Accounting Staff', 'Finance', 5000000, 1000000, 'TK/0'),
(1, 'EMP-003', 'Mike Johnson', 'mike@company.com', '081212345678', 'Jl. Sudirman No. 30, Jakarta', '1992-12-10', '2021-06-01', 'IT Support', 'IT', 6000000, 1500000, 'K/1');

-- Sample Warehouses
INSERT INTO warehouses (company_id, code, name, address) VALUES
(1, 'WH-001', 'Main Warehouse', 'Jl. Industri No. 1, Jakarta'),
(1, 'WH-002', 'Branch Warehouse', 'Jl. Raya Bogor No. 100, Jakarta');

-- Sample Inventory
INSERT INTO inventory_locations (item_id, warehouse_id, quantity_on_hand, average_cost, total_value) VALUES
(1, 1, 10, 7500000, 75000000),
(2, 1, 25, 150000, 3750000),
(3, 1, 5, 2500000, 12500000),
(4, 1, 15, 1200000, 18000000),
(5, 1, 100, 50000, 5000000);

-- Sample Banks
INSERT INTO banks (company_id, code, bank_name, account_number, account_name, account_type, initial_balance, current_balance) VALUES
(1, 'BNK-001', 'Bank Mandiri', '1234567890', 'PT Financial System', 'CHECKING', 40000000, 40000000),
(1, 'BNK-002', 'BCA', '0987654321', 'PT Financial System', 'SAVINGS', 10000000, 10000000);

-- Sample Sales Invoice
INSERT INTO sales_invoices (company_id, invoice_number, customer_id, invoice_date, due_date, subtotal, tax_amount, total_amount, status) VALUES
(1, 'INV-2024-001', 1, '2024-01-15', '2024-02-14', 45000000, 4500000, 49500000, 'PAID'),
(1, 'INV-2024-002', 2, '2024-01-20', '2024-02-19', 25000000, 2500000, 27500000, 'SENT');

-- Sample Sales Invoice Items
INSERT INTO sales_invoice_items (sales_invoice_id, item_id, quantity, unit_price, total_price) VALUES
(1, 1, 2, 7500000, 15000000),
(1, 2, 10, 150000, 1500000),
(1, 3, 1, 2500000, 2500000),
(1, 4, 5, 1200000, 6000000),
(1, 5, 20, 50000, 1000000);

-- Sample Purchase Order
INSERT INTO purchase_orders (company_id, po_number, supplier_id, order_date, expected_date, subtotal, tax_amount, total_amount, status) VALUES
(1, 'PO-2024-001', 1, '2024-01-10', '2024-01-20', 30000000, 3000000, 33000000, 'RECEIVED');

-- Sample Purchase Order Items
INSERT INTO purchase_order_items (purchase_order_id, item_id, quantity, unit_price, total_price) VALUES
(1, 1, 5, 7000000, 35000000),
(1, 2, 30, 140000, 4200000);

-- Sample Journal Entry
INSERT INTO journal_entries (company_id, transaction_no, transaction_date, description, total_amount, is_posted, created_by) VALUES
(1, 'JE-2024-001', '2024-01-15', 'Monthly sales revenue', 49500000, 1, 1);

-- Sample Journal Entry Details
INSERT INTO journal_entry_details (journal_entry_id, account_id, description, debit_amount, credit_amount) VALUES
(1, 1, 'Cash received from sales', 49500000, 0),
(1, 9, 'Sales revenue', 0, 45000000),
(1, 19, 'Output VAT', 0, 4500000);

-- Sample Inventory Movement
INSERT INTO inventory_movements (company_id, item_id, warehouse_id, movement_type, reference_type, reference_id, quantity, unit_cost, total_cost, balance_quantity, movement_date, created_by) VALUES
(1, 1, 1, 'IN', 'PURCHASE', 1, 5, 7000000, 35000000, 15, '2024-01-15', 1),
(1, 1, 1, 'OUT', 'SALE', 1, 2, 7500000, 15000000, 13, '2024-01-15', 1);

COMMIT;