<?php
// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'financial_system');
define('DB_USER', 'root');
define('DB_PASS', '');

// Application Configuration
define('APP_NAME', 'Financial Management System');
define('APP_VERSION', '1.0.0');
define('BASE_URL', 'http://localhost/financial-system/');
define('UPLOAD_PATH', __DIR__ . '/../uploads/');
define('REPORT_PATH', __DIR__ . '/../reports/');

// Security Configuration
define('ENCRYPTION_KEY', 'your-secret-encryption-key-change-this');
define('SESSION_TIMEOUT', 3600); // 1 hour
define('CSRF_TOKEN_TIMEOUT', 300); // 5 minutes

// Pagination Configuration
define('ITEMS_PER_PAGE', 25);
define('MAX_FILE_SIZE', 5242880); // 5MB

// Date/Time Configuration
date_default_timezone_set('Asia/Jakarta');
setlocale(LC_TIME, 'id_ID');

// Error Reporting
define('DEBUG_MODE', true);
if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Start Session
session_start();

// Require Composer Autoload
require_once __DIR__ . '/../vendor/autoload.php';
?>