<?php
require_once '../../config/config.php';
require_once '../../config/database.php';
require_once '../../libraries/Auth.php';

header('Content-Type: application/json');

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

if (!$auth->hasPermission('inventory')) {
    http_response_code(403);
    echo json_encode(['error' => 'Forbidden']);
    exit();
}

$db = new Database();
$companyId = $_SESSION['company_id'] ?? 1;

try {
    $id = $_POST['id'] ?? null;
    $code = $_POST['code'] ?? '';
    $name = $_POST['name'] ?? '';
    $categoryId = $_POST['category_id'] ?? null;
    $unitOfMeasure = $_POST['unit_of_measure'] ?? '';
    $costMethod = $_POST['cost_method'] ?? 'FIFO';
    $minStock = $_POST['min_stock'] ?? 0;
    $maxStock = $_POST['max_stock'] ?? 0;
    $isActive = $_POST['is_active'] ?? 1;
    $description = $_POST['description'] ?? '';
    
    // Validation
    if (empty($code) || empty($name)) {
        throw new Exception('Required fields are missing');
    }
    
    // Check for duplicate code
    $db->query("SELECT id FROM items WHERE code = :code AND company_id = :company_id AND id != :id");
    $db->bind(':code', $code);
    $db->bind(':company_id', $companyId);
    $db->bind(':id', $id ?: 0);
    
    if ($db->single()) {
        throw new Exception('Item code already exists');
    }
    
    if ($id) {
        // Update existing item
        $db->query("
            UPDATE items 
            SET code = :code,
                name = :name,
                category_id = :category_id,
                unit_of_measure = :unit_of_measure,
                cost_method = :cost_method,
                min_stock = :min_stock,
                max_stock = :max_stock,
                is_active = :is_active,
                description = :description,
                updated_at = NOW()
            WHERE id = :id AND company_id = :company_id
        ");
        
        $db->bind(':id', $id);
        $db->bind(':code', $code);
        $db->bind(':name', $name);
        $db->bind(':category_id', $categoryId);
        $db->bind(':unit_of_measure', $unitOfMeasure);
        $db->bind(':cost_method', $costMethod);
        $db->bind(':min_stock', $minStock);
        $db->bind(':max_stock', $maxStock);
        $db->bind(':is_active', $isActive);
        $db->bind(':description', $description);
        $db->bind(':company_id', $companyId);
        
    } else {
        // Insert new item
        $db->query("
            INSERT INTO items 
            (company_id, code, name, description, category_id, unit_of_measure, 
             cost_method, min_stock, max_stock, is_active)
            VALUES 
            (:company_id, :code, :name, :description, :category_id, :unit_of_measure,
             :cost_method, :min_stock, :max_stock, :is_active)
        ");
        
        $db->bind(':company_id', $companyId);
        $db->bind(':code', $code);
        $db->bind(':name', $name);
        $db->bind(':description', $description);
        $db->bind(':category_id', $categoryId);
        $db->bind(':unit_of_measure', $unitOfMeasure);
        $db->bind(':cost_method', $costMethod);
        $db->bind(':min_stock', $minStock);
        $db->bind(':max_stock', $maxStock);
        $db->bind(':is_active', $isActive);
    }
    
    $db->execute();
    
    echo json_encode([
        'success' => true,
        'message' => 'Item saved successfully'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>