<?php
require_once '../../config/config.php';
require_once '../../config/database.php';
require_once '../../libraries/Auth.php';

header('Content-Type: application/json');

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

$db = new Database();
$companyId = $_SESSION['company_id'] ?? 1;

try {
    $db->query("
        SELECT 
            coa.*,
            at.name as type_name,
            at.account_category as category,
            at.normal_balance
        FROM chart_of_accounts coa
        JOIN account_types at ON coa.account_type_id = at.id
        WHERE coa.company_id = :company_id
        ORDER BY coa.account_code ASC
    ");
    
    $db->bind(':company_id', $companyId);
    $accounts = $db->resultSet();
    
    echo json_encode([
        'success' => true,
        'accounts' => $accounts
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>